package gov.va.genisis2Test.daoImp;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateTemplate;

import gov.va.genisis2.dao.impl.LookUpDao;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;

/**
 * The Class LookUpDaoTest.
 *
 * @author1 Janet Lopez
 * 
 *          The Class LookUpDaoTest.
 * 
 *          Description: In this LookUpDaoTest Class which extends the abstract
 *          class, AbstractMockMvcTests, junit tests are defined.
 */

public class LookUpDaoTest extends AbstractMockMvcTests {
	
	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(LookUpDaoTest.class);

	/**
	 * This method is used to test hibernate template.
	 */
	@Test
	public void TestGetTemplate() {
		// testing for Hibernate Template
		logger.info("**********Junit Test Get Template**********");

		LookUpDao lookUpDao = new LookUpDao();
		HibernateTemplate hibernateTemplate = lookUpDao.getHibernateTemplate();
		// for coverage
		Assert.assertNull(hibernateTemplate);
		lookUpDao.setHibernateTemplate(getMockHibernateTemplate());
		hibernateTemplate = lookUpDao.getHibernateTemplate();
		Assert.assertNotNull(hibernateTemplate);
	}

	
	/**
	 * Test get status id.
	 */
	@Test
	public void TestGetStatusId() {
		
		logger.info("**********Junit Test Get Status Id**********");

		String statusDescription = "Submitted";
		int id = getMockLookUpDao().getStatusId(statusDescription);
	}	
}
